#!/usr/bin/env python
from flask import Flask, request, redirect
import requests
import json
app = Flask(__name__)

# Pabbly API URL
API_ENDPOINT = "https://payments.pabbly.com/api/v1/verifyhosted"
# http headers to be sent to api
headers = {'Authorization': "Basic <BASIC_AUTH_HTTP_HEADER_STRING>"}

@app.route('/payfast-subscription/pabbly-form', methods=['GET', 'POST']) #allow only POST requests
def form_pabbly():

    hostedpage = request.args.get('hostedpage')

    data = {'hostedpage': hostedpage}

    # forward request to pabbly 'Verify Hosted Page' API to retrieve form information
    r = requests.post(url=API_ENDPOINT, headers=headers, data=data)

    # capture form data as json
    form_data = json.loads(r.text)

    # fetch amount field from form
    package_amount = form_data['data']['amount']

    # convert amount data from int to string
    package_amount_str = str(package_amount)


    # set payfast URL with ZAR price
    # recurring payments??
    location = "https://www.payfast.co.za/eng/process?cmd=_paynow&receiver=<MERCHANT_ID>&item_name=<ITEM_NAME>&amount=" + package_amount_str + "&cycles=0&frequency=3&m_subscription_id=pay_now_<MERCHANT_ID>&m_payment_id=pay_now_<MERCHANT_ID>&subscription_type=1"


    # respond with HTTP 301 redirect to Payfast with all required parameters
    return redirect(location, code=301)

if __name__ == '__main__':
    app.run(host='<VPS_PUBLIC_IP>,port=5000)